#include <WiFi.h>
 
const char* ssid = "xx";
const char* password =  "xx";

#define RELAY1 2   // RELAY TRM12
 
WiFiServer wifiServer(80);

 
void setup() {
 
  Serial.begin(9600);
  
  // relay outputs
  pinMode(RELAY1, OUTPUT);
  
  delay(1000);
 
  WiFi.begin(ssid, password);
 
  while (WiFi.status() != WL_CONNECTED) {
   delay(1000);
   Serial.println("Wait Connecting to WiFi..");
  }
 
  Serial.println("Connected to the WiFi network");
  Serial.println(WiFi.localIP());
  wifiServer.begin();

   digitalWrite(RELAY1, HIGH);  
   delay(200);
   digitalWrite(RELAY1, LOW);  
}
 
void loop() {
 
  WiFiClient client = wifiServer.available();
 
  if (client) {
 
    while ( client.connected() ) {
   
      while (client.available() > 0) {
        char c = client.read();
        if (c=='1')      digitalWrite(RELAY1, HIGH);  
        else             digitalWrite(RELAY1, LOW);  
        
       // Send char to Server On TCP
       // client.write(c);
       Serial.println(c);
       //delay(1);
      
      }
     }
 
    client.stop();
    Serial.println("Client disconnected");
 
  }
}
